from gtts import gTTS
import os
import IPython.display as ipd


from IPython.display import Audio

def gtts_tts(text, lang='en', output_file="gTTS_output.mp3"):
    """
    Convert text to speech using gTTS and save the output as an audio file.

    Args:
    text (str): The text to be converted to speech.
    lang (str): The language of the text. Default is 'en' (English).
    output_file (str): The name of the output audio file. Default is "gTTS_output.mp3".

    Returns:
    str: Path to the generated audio file.
    """
    if not text:
        raise ValueError("Text for gTTS cannot be empty.")
    tts = gTTS(text=text, lang=lang, slow=False)
    tts.save(output_file)
    print(f"Audio saved as {output_file}")
    return output_file


def ask_gemini(user_question):
  import google.generativeai as genai

  # Configure the Gemini API
  genai.configure(api_key="Paste your key here")

  # Initialize the Gemini model
  model = genai.GenerativeModel("gemini-1.5-flash")

  # Check if the user provided a question
  if not user_question:
    print("No question entered. Please try again.")
    return None

  # Define a prompt encouraging a short, informative response
  prompt = f"Give me a quick, clear answer (3-4 lines) to this question: {user_question}. Be informative yet brief."

  try:
      # Generate the response using the model
      response = model.generate_content(prompt)
      # Return the generated response text
      return response.text.strip()
  except Exception as e:
      print(f"Error generating response with Gemini: {e}")
      return None
    
